﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using DataAccess;
using Newtonsoft;
using Newtonsoft.Json;
using System;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml;
using System.Xml.Linq;

/// <summary>
/// CPatientDemographics
/// Handles the data transactions and patient demographics page controls 
/// </summary>
public class CPatientDemographics
{
    protected BaseMaster m_BaseMstr { set; get; }

    /// <summary>
    /// Class constructor
    /// </summary>
    /// <param name="BaseMstr"></param>
    public CPatientDemographics(BaseMaster BaseMstr)
	{
        m_BaseMstr = BaseMstr;
	}

    /// <summary>
    /// US:5959,5960
    /// Returns demographics dataset to populate patient demographics page controls
    /// </summary>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public DataSet GetPatientDemographicsDS(string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_vKey", m_BaseMstr.Key);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_PATIENT.GetPatientDemographicsRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:5961
    /// Returns socioeconomic dataset to populate the socioeconomic tab in patient demographics page
    /// </summary>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public DataSet GetPatientSocioeconomicsDS(string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_vKey", m_BaseMstr.Key);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_PATIENT.GetPatientSocioeconomicsRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Returns patient's race dataset
    /// </summary>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public DataSet GetPatientRaceDS(string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", strPatientID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_PAT_ETHNICITY_RACE.GetPatientRaceRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Returns patient's ethnicity dataset
    /// </summary>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public DataSet GetPatientEthnicityDS(string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", strPatientID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_PAT_ETHNICITY_RACE.GetPatientEthnicityRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:5912 US:5960 US:7242
    /// Updates patient demographics record with the patient demographics page data
    /// </summary>
    /// <param name="strFName"></param>
    /// <param name="strMi"></param>
    /// <param name="strLName"></param>
    /// <param name="strSponsorSSN"></param>
    /// <param name="strSSN"></param>
    /// <param name="strGender"></param>
    /// <param name="strDOB"></param>
    /// <param name="strProviderID"></param>
    /// <param name="strAddress1"></param>
    /// <param name="strAddress2"></param>
    /// <param name="strCity"></param>
    /// <param name="strPostalCode"></param>
    /// <param name="strHomePhone"></param>
    /// <param name="strCellPhone"></param>
    /// <param name="strWorkPhone"></param>
    /// <param name="strEmail"></param>
    /// <param name="strStateID"></param>
    /// <param name="lCallPreference"></param>
    /// <param name="lHomePhoneMsg"></param>
    /// <param name="lEmailMsg"></param>
    /// <returns></returns>
    public bool UpdatePatientDemographics(string strFName,
                                    string strMi,
                                    string strLName,
                                    string strSponsorSSN,
                                    string strSSN,
                                    string strGender,
                                    string strDOB,
                                    string strProviderID,
                                    string strAddress1,
                                    string strAddress2,
                                    string strCity,
                                    string strPostalCode,
                                    string strHomePhone,
                                    string strCellPhone,
                                    string strWorkPhone,
                                    string strEmail,
                                    string strStateID,
                                    long lDutyStatusID,
                                    long lPrefLangID,
                                    string strPrefLangOther,
                                    long lHandPrefID,
                                    long lCallPreference,
                                    long lHomePhoneMsg,
                                    long lEmailMsg)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID, m_BaseMstr.ClientIP, m_BaseMstr.FXUserID);

        /*
        pi_nPrefLangID      in number,
        pi_vPrefLangOther   in varchar2,
        pi_nDutyStatusID    in number,
        pi_nHandPrefID      in number,
         */

        //add params for the DB stored procedure call
        //Patient Table
        plist.AddInputParameter("pi_vKey", m_BaseMstr.Key);
        plist.AddInputParameter("pi_vPatientID", m_BaseMstr.SelectedPatientID);
        plist.AddInputParameter("pi_vFirstName", strFName);
        plist.AddInputParameter("pi_vMI", strMi);
        plist.AddInputParameter("pi_vLastName", strLName);
        plist.AddInputParameter("pi_vSponsorSSN", strSponsorSSN);
        plist.AddInputParameter("pi_vSSN", strSSN);
        plist.AddInputParameter("pi_vGender", strGender);
        plist.AddInputParameter("pi_vDateOfBirth", strDOB);
        plist.AddInputParameter("pi_vProviderID", strProviderID);
        plist.AddInputParameter("pi_vAddress1", strAddress1);
        plist.AddInputParameter("pi_vAddress2", strAddress2);
        plist.AddInputParameter("pi_vCity", strCity);
        plist.AddInputParameter("pi_vPostal_Code", strPostalCode);
        plist.AddInputParameter("pi_vHomePhone", strHomePhone);
        plist.AddInputParameter("pi_vCellPhone", strCellPhone);
        plist.AddInputParameter("pi_vWorkPhone", strWorkPhone);
        plist.AddInputParameter("pi_vEmail", strEmail);
        plist.AddInputParameter("pi_vStateID", strStateID);

        plist.AddInputParameter("pi_nPrefLangID", lPrefLangID);
        plist.AddInputParameter("pi_vPrefLangOther", strPrefLangOther);
        plist.AddInputParameter("pi_nDutyStatusID", lDutyStatusID);
        plist.AddInputParameter("pi_nHandPrefID", lHandPrefID);

        plist.AddInputParameter("pi_nCallPreference", lCallPreference);
        plist.AddInputParameter("pi_nCellPhoneMsg", lHomePhoneMsg);
        plist.AddInputParameter("pi_nEmailMsg", lEmailMsg);

        //get a dataset from the sp call todo change call to executeSP and use connection to
        //switch on type and call correct code
        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_PATIENT.UpdatePatientDemographics",
                                          plist,
                                          out lStatusCode,
                                          out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }

    /// <summary>
    /// US:5961
    /// Updates patient socioeconomics record with the patient demographics page data
    /// </summary>
    /// <param name="lHighestGradeID"></param>
    /// <param name="lHighestDegreeID"></param>
    /// <param name="lMaritalStatusID"></param>
    /// <param name="lEmploymentStatusID"></param>
    /// <param name="lJobClassificationID"></param>
    /// <param name="strEmploymentStatusOther"></param>
    /// <returns></returns>
    public bool UpdatePatientSocioeconomics(long lHighestGradeID,
                                            long lHighestDegreeID,
                                            long lMaritalStatusID,
                                            long lEmploymentStatusID,
                                            long lJobClassificationID,
                                            string strEmploymentStatusOther)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID, m_BaseMstr.ClientIP, m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vKey", m_BaseMstr.Key);
        plist.AddInputParameter("pi_vPatientID", m_BaseMstr.SelectedPatientID);
        plist.AddInputParameter("pi_nHighestGradeID", lHighestGradeID);
        plist.AddInputParameter("pi_nHighestDegreeID", lHighestDegreeID);
        plist.AddInputParameter("pi_nMaritalStatusID", lMaritalStatusID);
        plist.AddInputParameter("pi_nEmploymentStatusID", lEmploymentStatusID);
        plist.AddInputParameter("pi_nJobClassificationID", lJobClassificationID);
        plist.AddInputParameter("pi_vEmploymentStatusOther", strEmploymentStatusOther);

        //get a dataset from the sp call todo change call to executeSP and use connection to
        //switch on type and call correct code
        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_PATIENT.UpdatePatientSocioeconomics",
                                          plist,
                                          out lStatusCode,
                                          out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }

    /// <summary>
    /// Updates patient race record with values from patient demographics page
    /// </summary>
    /// <param name="strValues"></param>
    /// <returns></returns>
    public bool UpdatePatientRace(string strValues)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID, m_BaseMstr.ClientIP, m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", m_BaseMstr.SelectedPatientID);
        plist.AddInputParameter("pi_vValues", strValues);

        //get a dataset from the sp call todo change call to executeSP and use connection to
        //switch on type and call correct code
        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_PAT_ETHNICITY_RACE.UpdatePatientRace",
                                          plist,
                                          out lStatusCode,
                                          out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }

    /// <summary>
    /// Updates patient ethnicity record with values from patient demographics page
    /// </summary>
    /// <param name="lEthnicityID"></param>
    /// <returns></returns>
    public bool UpdatePatientEthnicity(long lEthnicityID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID, m_BaseMstr.ClientIP, m_BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        plist.AddInputParameter("pi_vPatientID", m_BaseMstr.SelectedPatientID);
        plist.AddInputParameter("pi_nEthnicityID", lEthnicityID);

        //get a dataset from the sp call todo change call to executeSP and use connection to
        //switch on type and call correct code
        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_PAT_ETHNICITY_RACE.UpdatePatientEthnicity",
                                          plist,
                                          out lStatusCode,
                                          out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }

}